.ifndef __BOSS_SELECTION_ASM__
.define __BOSS_SELECTION_ASM__

.define QuickManHornLocation VramWrite | $38b2
.define PositionFirstFace VramWrite | $38cc
.define FirstTileFacePosition 0
.define bossIntroText tempVars + 
.define bossTimers bossIntroText + BossText.size
.define bossSelection.ramPalette bossTimers + BossTimers.size
.define bossSelection.ramBlinkPalette bossSelection.ramPalette + bossSelection.palette.size

.bank 0 slot 0

.section "bossSelection.bossAddressAttributesTable" align $100 free
bossSelection.bossAddressAttributesTable:
	.db	$01 bubbleManTilesBank
	.dw bubbleManPalette
	.db $02 airManTilesBank
	.dw airManPalette
	.db $04 quickManTilesBank
	.dw quickManPalette
	.db $08 heatManTilesBank
	.dw heatManPalette
	.db $10	woodManTilesBank
	.dw woodManPalette
	.db $20 metalManTilesBank
	.dw metalManPalette
	.db $40 flashManTilesBank
	.dw flashManPalette
	.db $80 crashManTilesBank
	.dw crashManPalette
.ends

.section "bossSelection.cursorPosition" align $100 free
bossSelection.cursorPosition:
	.db 0*64, 0*64, 1*64, 0*64
	.db 1*64, 0*64, 2*64, 1*64
	.db 2*64, 1*64, 2*64, 2*64
.ends


;loads the bossSelection tilemap into vram
;it's here, and not in the map loaders because it's only loaded here
.macro bossSelection.loadMap
	ld hl, column.columnAddress
	ld (hl), 32
	inc l
	ld bc, $0198
	call bossSelection.loadTileToColumn
	fastLdir 27*2
	
	ld de, 6
	
	ld hl, column.buffer + 2
	ld (hl), e
	inc l
	ld (hl), d
	
	ld l,  <column.buffer + 54
	ld (hl), e
	inc l
	ld (hl), d
	
	ld hl, bossSelectionMapLastColumn
---:	ld de, column.buffer + 4 ;put the destination pointer back to the begining
		push hl	;save the global origin pointer
		ld l, (hl)
		
		ld c, 27 ;load counter 3 + 3*8(number of entries)
--:			push hl
			ld b, 8
-:				ld a, (hl)
				rla
				rla
				and 1
				
				ldi
				ld (de), a
				inc e
			djnz -
			pop hl
			dec c
		jr nz, --
		
		ld c, VdpDataPort
		ld hl, column.columnAddress
		dec (hl)
		call outputColumn
		pop hl
		dec l
	jp p, ---

.endm


;loads a 32x32 boss face or wily logo into the screen
.macro bossSelection.loadBossFace
	push af
	ld a, 1
	ld e, 4
--:		ld c, VdpControlPort
		out (c), l
		out (c), h
		dec c
	
		ld b, 4
-:			out (c), d	
			inc d
			out (VdpDataPort), a
		djnz -
		ld c, 64
		add hl, bc
		dec e
	jr nz, --
	pop af
.endm

;get the position of the cursor and converts to a address
;in the bossAddressAttributesTable
; \1 address to jump in case the cursor is over wili logo
;return:
; hl: Address on the bossAddressAttributesTable
;  a: copy of l
.macro bossSelection.cursorPostionToAddress
	ld hl, objectTable.2.y
	ld a, (hl)
	rlca
	rlca
	ld b, a
	rlca		; multiply by 2
	add a, b 	; multiply by 3
	ld b, a
	ld l, <objectTable.2.x
	ld a, (hl)
	rlca
	rlca
	add a, b
	cp $04
	jp z, \1
	jp m, bossSelection.cursorPostionToAddress.ignoreDec
		dec a
bossSelection.cursorPostionToAddress.ignoreDec:
	rlca
	rlca
	ld l, a
	ld h, >bossSelection.bossAddressAttributesTable
.endm

;hl: position in the column buffer
;bc: name table entry
;return:
;de: will be positioned two positions ahead of hl
;hl: will be preserved
.section "bossSelection.loadTileToColumn" free
bossSelection.loadTileToColumn:
	ld (hl), c
	inc l
	ld (hl), b
	ld d, h
	ld e, l
	dec l
	inc e
	ret
.ends

;blinks the screen while loading boss animation timers, name, palettes
;and tiles.
;returns:
; boss palette to palette buffer (in the last 8 entries)
; tiles to vram, starting on $14 index
; animation timers on temp var bossTimers
; boss name on bossIntroText
.macro blinkScreenLoadingBossStuff
	push hl
	;loads those palette on a temp location since this function will potentially swap banks
	ld de, bossSelection.ramPalette
	ld hl, bossSelection.palette
	fastLdir bossSelection.palette.size*2	;2 because it has to load both the regular palette and the blink palette
	pop hl
	
	ld a, (hl)
	ld (MapperSlot2), a
	inc l
	ld e, (hl)
	inc l
	ld d, (hl)
	
	ld hl, palette.buffer + 24
	ex de, hl
	fastLdir 8
	
	ld de, bossIntroText
	fastLdir 11
	ld a, (hl)
	ld (objectTable.2.objType), a
	inc hl
	
	ex de, hl
	
	ld ixl, e
	ld ixh, d
	
	ld hl, VramWrite | (20*32)
	ld (tileDecompVramPtr),hl 
	
	call clearSpriteTable
	call prepareForVblank
teste:
	ld b, $34
--:		push bc
		ld a, %00000011
		and b
		jr nz, ++
			ld hl, bossSelection.ramBlinkPalette
			ld a, %00000100
			and b
			jr nz, +
				ld l, <bossSelection.ramPalette
+:			ld de, palette.hasNewPalette
			fastLdir bossSelection.palette.size
++:		ld c, 4
-:			call decompressSingleTile
			dec c
		jr nz, -
		call prepareForVblank
		pop bc
	djnz --
.endm

.section "bossSelection" free
bossSelection:
	call turnOffVdp
	ld a, 16
	out (VdpControlPort), a
	ld a, CramWrite.hi
	out (VdpControlPort), a
	xor a
	out (VdpDataPort), a
	
	decompress bossSelectionTiles, 0, bossSelectionTilesCount
	decompress bossFacesTiles, 256*32, bossFacesTilesCount
	bossSelection.loadMap
	
	ld hl, PositionFirstFace
	ld a, (bossesBeaten)
	ld d, FirstTileFacePosition
		; bf  ol  bf
	ld c, 3 + 1 + 2 ;this counter have two functions, when hit zero for the first time,
					;its time to place the willy logo instead a boss face.
					;ol: outer loop, bf: boss faces
----:	ld b, 3
---:	dec c
		jr z, +		;Write Wily logo and re-value the counter
		rra
		jr nc, ++	;Write boss face
			ld e, a
			ld a, 16
			add a, d
			ld d, a
			ld a, e
			inc h
			push bc
		jr +++
			    ; bf  ol  bf  ol
+:			ld c, 1 + 1 + 3 + 1 ; when hits zero for the second time, its to exit the loop
++:			push bc
			bossSelection.loadBossFace
+++:		ld bc, -240
			add hl, bc
			pop bc
		djnz ---
		push bc
		ld bc, $1d0
		add hl, bc
		pop bc
		dec c
	jr nz, ----	
	
	;loads quick man horn
	ld a, (bossesBeaten)
	and QuickMan
	jr nz, +  
		ld a, <QuickManHornLocation
		out (VdpControlPort), a
		ld a, >QuickManHornLocation
		out (VdpControlPort), a
		ld a, 1
		out (VdpDataPort), a
		dec a
		out (VdpDataPort), a
+:	ld hl, bossSelection.text
	call loadPassiveText
	
	ld hl, bossSelection.palette
	ld de, palette.hasNewPalette
	fastLdir bossSelection.palette.size
	
	; loads cursor start position
	call clearObjectTable
	ld hl, objectTable.2.y
	ld a, 64
	ld (hl), a
	ld l, <objectTable.2.x
	ld (hl), a
	
	call turnOnVdp
backToLoop:
-:		call verticalObjectsToSprites
		call prepareForVblank
		ld a, StartKey | BKey
		and (hl)
		jr nz, ++
		ld a, UKey | DKey | LKey | RKey
		and (hl)
		ld d, >bossSelection.cursorPosition
		ld b, 4
		call updateCursorPosition
		ld a, (frameCounter)
		ld l, <objectTable.2.objType
		and $08
		ld a, objects.bossSelection.cursor
		jr z, +
			xor a
+:		ld (hl), a
	jr -
++:	

	bossSelection.cursorPostionToAddress runWilyMusic

	ld a, (bossesBeaten)
	and (hl)
	jr nz, -
	inc l
	blinkScreenLoadingBossStuff
	call PSGStop
	ret
runWilyMusic:
	
	ld a, (PSGMusicStatus)
	or a
	jp z, +
	call PSGStop
	jp backToLoop
	
+:	ld hl, wilyStage1Music
	call PSGPlay
	jp backToLoop
	ret
.ends

.endif


